/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw.tasks.networksettings;

import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.tasks.networksettings.NetworkSettingsConstants;
import com.ibm.hwmca.fw.util.LocalizableText;
import java.io.Serializable;

public class NetworkSettingsLANName
implements Serializable,
NetworkSettingsConstants {
    private static final String TRACE_MASKD = "JNSWNSYD";
    private static final String TRACE_MASKF = "JNSWNSYF";
    private static final String TRACE_MASKT = "JNSWNSYT";
    public String m_sLANAdapterMACAdr = "";
    public String m_sLANAdapterIPAdr = "";
    public String m_sLANAdapterIfName = "";
    public int m_iLANAdapterType = 0;
    public boolean m_bConfiguredThisSession = false;
    public boolean m_bVisible = true;
    public int m_iInterfaceType = 2;
    public int m_iAddressType = 3;
    public boolean m_bNSConfigured = false;
    public boolean m_bNetworkType = true;
    public boolean m_bAddressType = true;

    public NetworkSettingsLANName() {
    }

    public NetworkSettingsLANName(String string, String string2, String string3, int n) {
        this.m_sLANAdapterIfName = string2;
        this.m_sLANAdapterIPAdr = string3;
        this.m_iLANAdapterType = n;
        this.buildMACAdr(string);
    }

    public NetworkSettingsLANName(String string, String string2, int n) {
        this.m_sLANAdapterIfName = string2;
        this.m_iLANAdapterType = n;
        this.buildMACAdr(string);
    }

    public String getLANAdapterName() {
        String string = "";
        Object[] objectArray = new String[3];
        objectArray[0] = this.m_sLANAdapterIfName;
        objectArray[2] = this.m_sLANAdapterMACAdr;
        if (this.m_sLANAdapterIPAdr != null && this.m_sLANAdapterIPAdr.length() > 0) {
            objectArray[1] = this.m_sLANAdapterIPAdr;
            string = new LocalizableText("com.ibm.hsc.common.bundles.NetworkSettingsText", "NETWORKSETTINGS_LANNAME_LANNAME", objectArray).toString();
        } else {
            string = new LocalizableText("com.ibm.hsc.common.bundles.NetworkSettingsText", "NETWORKSETTINGS_LANNAME_LANNAME_SHORT", objectArray).toString();
        }
        return string;
    }

    public String getLANAdapterMACAdr() {
        return this.m_sLANAdapterMACAdr;
    }

    public void setLANAdapterMACAdr(String string) {
        this.m_sLANAdapterMACAdr = string;
    }

    public String getLANAdapterIPAdr() {
        return this.m_sLANAdapterIPAdr;
    }

    public void setLANAdapterIPAdr(String string) {
        this.m_sLANAdapterIPAdr = string;
    }

    public String getLANAdapterIfName() {
        return this.m_sLANAdapterIfName;
    }

    public void setLANAdapterIfName(String string) {
        this.m_sLANAdapterIfName = string;
    }

    public int getLANAdapterType() {
        return this.m_iLANAdapterType;
    }

    public String getLANAdapterTypeString() {
        String string = "";
        switch (this.m_iLANAdapterType) {
            case 0: {
                string = new LocalizableText("com.ibm.hsc.common.bundles.NetworkSettingsText", "NETWORKSETTINGS_LANNAME_UNKNOWN").toString();
                break;
            }
            case 1: {
                string = new LocalizableText("com.ibm.hsc.common.bundles.NetworkSettingsText", "NETWORKSETTINGS_LANNAME_TOKENRING").toString();
                break;
            }
            case 2: {
                string = new LocalizableText("com.ibm.hsc.common.bundles.NetworkSettingsText", "NETWORKSETTINGS_LANNAME_ETHERNET").toString();
                break;
            }
            default: {
                string = new LocalizableText("com.ibm.hsc.common.bundles.NetworkSettingsText", "NETWORKSETTINGS_LANNAME_UNKNOWN").toString();
            }
        }
        return string;
    }

    public void setLANAdapterType(int n) {
        this.m_iLANAdapterType = n;
    }

    private void buildMACAdr(String string) {
        int n = string.length();
        String string2 = "";
        for (int i = 0; i < n && i < 24; i += 2) {
            string2 = string2 + string.substring(i, i + 2);
            if (i >= n - 2) continue;
            string2 = string2 + ":";
        }
        this.m_sLANAdapterMACAdr = string2;
    }

    public boolean isConfiguredThisSession() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsLANName isConfiguredThisSession called: ConfiguredThisSession =  " + this.m_bConfiguredThisSession);
        }
        return this.m_bConfiguredThisSession;
    }

    public void setConfiguredThisSession(boolean bl) {
        this.m_bConfiguredThisSession = bl;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsLANName setConfiguredThisSession called: ConfiguredThisSession =  " + this.m_bConfiguredThisSession);
        }
    }

    public boolean isVisible() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsLANName isVisible called: Visible =  " + this.m_bVisible);
        }
        return this.m_bVisible;
    }

    public void setVisible(boolean bl) {
        this.m_bVisible = bl;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsLANName setVisible called: Visible =  " + this.m_bVisible);
        }
    }

    public int getInterfaceType() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsLANName getInterfaceType called: InterfaceType =  " + this.m_iInterfaceType);
        }
        return this.m_iInterfaceType;
    }

    public void setInterfaceType(int n) {
        this.m_iInterfaceType = n;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsLANName setInterfaceType called: InterfaceType =  " + this.m_iInterfaceType);
        }
    }

    public int getAddressType() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsLANName getAddressType called: AddtessType =  " + this.m_iAddressType);
        }
        return this.m_iAddressType;
    }

    public void setAddressType(int n) {
        this.m_iAddressType = n;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsLANName setAddressType called: AddressType =  " + this.m_iAddressType);
        }
    }

    public boolean isNSConfigured() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsLANName isNSConfigured called: NSConfigured =  " + this.m_bNSConfigured);
        }
        return this.m_bNSConfigured;
    }

    public void setNSConfigured(boolean bl) {
        this.m_bNSConfigured = bl;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsLANName setNSConfigured called: NSConfigured =  " + this.m_bNSConfigured);
        }
    }

    public boolean isPrivateIf() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsLANName isPrivateIf called: PrivateIf =  " + this.m_bNetworkType);
        }
        return this.m_bNetworkType;
    }

    public void setPrivateIf(boolean bl) {
        this.m_bNetworkType = bl;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsLANName setPrivateIf called: PrivateIf =  " + this.m_bNetworkType);
        }
    }

    public boolean isSpecifiedAddress() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsLANName isSpecifiedAddress called: SpecifiedAddress =  " + this.m_bAddressType);
        }
        return this.m_bAddressType;
    }

    public void setSpecifiedAddress(boolean bl) {
        this.m_bAddressType = bl;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettingsLANName setSpecifiedAddress called: SpecifiedAddress =  " + this.m_bAddressType);
        }
    }

    public boolean equals(NetworkSettingsLANName networkSettingsLANName) {
        boolean bl = false;
        bl = networkSettingsLANName.getLANAdapterIfName().trim().equals(this.getLANAdapterIfName().trim()) && networkSettingsLANName.getLANAdapterIPAdr().trim().equals(this.getLANAdapterIPAdr().trim()) && networkSettingsLANName.getLANAdapterMACAdr().trim().equals(this.getLANAdapterMACAdr().trim()) && networkSettingsLANName.getLANAdapterType() == this.getLANAdapterType();
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "--NetworkSettingsLANName equals: " + networkSettingsLANName.getLANAdapterName() + " = " + this.getLANAdapterName() + " is " + bl);
        }
        return bl;
    }
}

